%-------------------------------------------------------------------------------
% Project Name:   Image Filter Arrays
% File Name:      MacBethAnalyis.m
% Authors:        JF Heukelman   005538085
%                 J Peterson     005567016
%                 Professor Brian Wandell
%                 Professor Joyce Farrell
% Class:          PSYCH221
% File Version:   1
% Description:    This file performs the analysis of the data collected during
%                 the MacBeth tests.
%-------------------------------------------------------------------------------

%{
ChartSize = [4,6]; % 4 rows, 6 columns
NumBlocks = ChartSize(1)*ChartSize(2);  % No of color blocks in MCC

% Get the height and width of the scene [height,width]
SceneHW = sceneGet(scene,'heightandwidth','mm');

% Get the height and width of the oi image [height,width]
oiHW = oiGet(oi,'heightandwidth','mm');

% Get the magnification of the image from the scene plane to the 
% sensor plane
optics = oiGet(oi,'optics');  
Mag = opticsGet(optics,'magnification');

% Get the height and width of the object in the image plane
ObjectHW = SceneHW.*abs(Mag);

% Get the number of samples in the oi image [row,cols]
oiSize = oiGet(oi,'size');

% Work out where the middle of each block is in the oi
oiCenter = oiSize./2;
BlockSize = (ObjectHW./ChartSize).*oiSize./oiHW;
GridW = (-(ChartSize(2)-1)/2):1:(ChartSize(2)-1)/2;
GridH = (-(ChartSize(1)-1)/2):1:(ChartSize(1)-1)/2;

BlockCentersH = oiCenter(1) + GridH.*BlockSize(1);
BlockCentersW = oiCenter(2) + GridW.*BlockSize(2);

% Round to integer for use in matrix subscripts
BlockCentersH = round(BlockCentersH);
BlockCentersW = round(BlockCentersW);

BlockCenters = [];

for r = 1:1:length(BlockCentersH);
   for c = 1:1:length(BlockCentersW);
        BlockCenters = [BlockCenters ; [BlockCentersH(r) BlockCentersW(c)]];
   end
end

% Now that we have the center of the blocks in the oi image we can 
% Get the XYZ color info

quanta = vcGetROIData(oi,BlockCenters,'photons');
wave = oiGet(oi,'wave');
oiXYZ = ieXYZFromPhotons(quanta,wave);

% Get the white point XYZ from the white square
oiWhitePoint = oiXYZ(19,:);


% Use the same method as before to get the centers of the Macbeth blocks 
% in the sensor coordinates, (make this calculation into a function later)

% Get the height and width of the sensor
SensorHW = sensorGet(sensor,'dimension','mm');

% Get the number of samples in the sensor image [rows,cols]
SensorSize = sensorGet(sensor,'size');

% Work out where the middle of each block is in the sensor
SensorCenter = SensorSize./2;
BlockSize = (ObjectHW./ChartSize).*SensorSize./SensorHW;

BlockCentersH = SensorCenter(1) + GridH.*BlockSize(1);
BlockCentersW = SensorCenter(2) + GridW.*BlockSize(2);

% Round to integer for use in matrix subscripts
BlockCentersH = round(BlockCentersH);
BlockCentersW = round(BlockCentersW);

BlockCenters = [];

% Put all the block coordinates into an array, row by row, starting from 
% upper left block. Format: [blockH blockW]
for r = 1:1:length(BlockCentersH);
   for c = 1:1:length(BlockCentersW);
        BlockCenters = [BlockCenters ; [BlockCentersH(r) BlockCentersW(c)]];
   end
end

%BlockCenters

SensorXYZ_all = imageGet(vci2,'dataxyz');
SensorXYZ = [];

for i = 1:1:NumBlocks
    row = BlockCenters(i,1);
    col = BlockCenters(i,2);
    X = SensorXYZ_all(row,col,1);
    Y = SensorXYZ_all(row,col,2);
    Z = SensorXYZ_all(row,col,3);
    
    SensorXYZ = [SensorXYZ ; X Y Z];
end

% Get the white point XYZ from the white square
SensorWhitePoint = SensorXYZ(19,:);


lab1 = vcXYZ2lab(oiXYZ, oiWhitePoint);
lab2 = vcXYZ2lab(SensorXYZ,SensorWhitePoint);
diffLAB = lab1 - lab2;

%diffLAB

for i=1:NumBlocks
  dEab(i) = norm( diffLAB(i,:));   
end

%dEab

% Get the avarge delta E value
deltaE_avg = mean(dEab)

%--- Jon's extra difference calculation ----
diffLAB2 = (lab1 - lab2) .^ 2;
ssd = sum(sum(diffLAB2))

%================================================================
%}

pointLoc = ...
    [94     2
    94   125
     9   125
     8     2];

% If you change the size of the sensor or other spatial parameters, you may
% have to adjust these.  You can use this routine to interactively click on
% the four corners of the MCC.  See the message in the processor window
% that tells you the order to click on the corners.
%
%[mRGB, mLocs, pSize, pointLoc] = ieMacbethSelect(vci);

% This produces several evaluations of the errors in the plot.
[macbethLAB, macbethXYZ, deltaE] = macbethColorError(vci,'D65',pointLoc);

% Create some variables used as metrics
deltaE_avg = mean(deltaE)

% End of File
